capture log close
clear all
macro drop _all
set more off
cd "C:\Users\alice\OneDrive\Alice QUANTONOMICS\Input substitution\Stata\1. NZ Data"
log using log/NZasset4, replace text

/*--------------------------------------------------------------------------
Project: Quantonomics DNSP Opex Cost Function Development Program
Author:  Michael Cunningham
File:    NZasset2.do
Initial Date:    22-Oct-2022
Revised Date:	 01-May-2025

Purpose: Read NZZ data for capital, and selected components of AUC
		 for the period 2013 to 2018

--------------------------------------------------------------------------*/

tempfile nzasset2a nzasset2b

*------------------------------------------------------------------------

import excel using data/EDB_ID__2022-2024__2024.05.01.xlsx, ///
	sheet("data") cellrange(A1:M371409) firstrow clear
describe

gen int eiid = 0
replace eiid = 2001 if edb == "Vector Lines"
replace eiid = 2002 if edb == "Powerco"
replace eiid = 2003 if edb == "Unison Networks"
replace eiid = 2004 if edb == "WEL Networks"
replace eiid = 2005 if edb == "Aurora Energy"
replace eiid = 2006 if edb == "Northpower"
replace eiid = 2007 if edb == "Electra"
replace eiid = 2008 if edb == "Network Tasman"
replace eiid = 2009 if edb == "Counties Energy"
replace eiid = 2010 if edb == "MainPower NZ"
replace eiid = 2011 if edb == "The Power Company"
replace eiid = 2012 if edb == "Top Energy"
replace eiid = 2013 if edb == "Alpine Energy"
replace eiid = 2014 if edb == "Eastland Network"
replace eiid = 2015 if edb == "Horizon Energy"
replace eiid = 2016 if edb == "Marlborough Lines"
replace eiid = 2017 if edb == "The Lines Company"
replace eiid = 2018 if edb == "Waipa Networks"
replace eiid = 2019 if edb == "Wellington Electricity"
drop if eiid == 0
labmask eiid, values(edb)

rename obs_yr year
 
gen varname = "."
	
replace varname = "VanillaWACC3" if schedule == "SCHEDULE 2: REPORT ON RETURN ON INVESTMENT" & ///
	section == "2(i): Return on Investment" ///
	& category == "ROI-comparable to a vanilla WACC" & sub_category == ///
	"Estimate of vanilla WACC" & description == "Mid-point estimate"	

replace varname = "tax" if section == ///
	"1(iv): Composition of regulatory income" & category == ///
	"Regulatory tax allowance" & description == "Regulatory tax allowance"

replace varname = "tax2" if section == ///
	"5a(i): Regulatory Tax Allowance" & category == ///
	"Regulatory tax allowance" & description == "Regulatory tax allowance"
	
replace varname = "infl" if section == ///
	"4(i): Regulatory Asset Base Value (Rolled Forward)" & category == ///
	"Total revaluations"	
	
replace varname = "depr" if section == ///
	"4(i): Regulatory Asset Base Value (Rolled Forward)" & category == ///
	"Total depreciation" & description == "Total depreciation"	
	
replace varname = "dispo" if section == ///
	"4(i): Regulatory Asset Base Value (Rolled Forward)" & category == ///
	"Asset disposals" & description == "Asset disposals"		
	
replace varname = "orab" if section == ///
	"4(i): Regulatory Asset Base Value (Rolled Forward)" & category == ///
	"Total opening RAB value" & description == "Total opening RAB value"
	
replace varname = "crab" if section == ///
	"4(i): Regulatory Asset Base Value (Rolled Forward)" & category == ///
	"Total closing RAB value" & description == "Total closing RAB value"	

replace varname = "CostDebt" if schedule == "SCHEDULE 2: REPORT ON RETURN ON INVESTMENT" & ///
	section == "2(ii): Information Supporting the ROI" ///
	& category == "ROI-comparable to a post tax WACC" & description == "Cost of debt assumption (%)"	


drop if varname == "."
*tab varname, m

keep eiid year varname value
sort varname eiid year 
duplicates drop


local varlist1 VanillaWACC3 tax tax2 infl depr dispo orab crab CostDebt
foreach k of local varlist1 {
	drop if varname == "`k'" & eiid == eiid[_n-1] & year == year[_n-1]
}

sort eiid year varname 
reshape wide value, i(eiid year) j(varname) string

foreach i of local varlist1 {
	rename value`i' `i'
}
sort eiid year

*Creating the Straight Line Depreciation
replace depr = depr + infl

drop tax2

foreach i of varlist infl depr orab crab CostDebt {
	replace `i' = . if `i' == 0
}

gen NVWACC = VanillaWACC3
drop VanillaWACC3 

describe, f
summarize

export excel xlsx/nzasset4.xlsx, replace firstrow(var) 
save dta/nzasset4, replace
 
log close
exit
